require( "scripts/style.lua" );


MyFont = {
  bigButtonFont,
  50,
  DarkRedColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
    deleteselected = true;
    playername = GetString("enternameprompt") ;
end


MakeDialog
{
    Bitmap
    {
        name="grayimage",
        image="backgrounds/shadow.png",
        alpha=true,
        x=0,
        y=0
    };
    Bitmap
    { 
        image="backgrounds/submit_hs.png",
        x=kCenter,
        y=kCenter,
        
        Text
        {
            font = MyFont,
            name = "entername",
            x=0,y=5,w=kMax,h=50,
            flags = kHAlignCenter + kVAlignTop,
            label = "entername"
        };
        
        Bitmap
        {
            image="backgrounds/textfield.png",
            x=kCenter,
            y=200,
            
            TextEdit
            {
                font = NameFont,
                name = "nameedit",
                label = playername,
                enablewindow = "enterok",
                clearinitial = deleteselected,
                x=8,y=14,w=kMax-3,h=kMax,
                length=20,
                ignore = kIllegalNameChars
            };
        };
    },
    Button
    {
        x=250, y=404,
        graphics = StButtonGraphicsSm,
        font = MenuButtonFont;
        name="enterok",
        label="ok",
        type = kPush,
        default=true,   -- Make this the default button
        command = 
            function()
                if (IsNameInUse(GetLabel("nameedit"))) then
                    DisplayDialog { 
                        "scripts/ok.lua", 
                        body ="nameinuse",
                        title = ""
                    };
                    SetFocus( "nameedit" )
                else
                    CloseWindow(GetLabel("nameedit"));
                end
            end
    },
    
    Button
    {
        x=412, y=404, --kMax-50,
        graphics = StButtonGraphicsSm,
        font = MenuButtonFont;
        name="entercancel",
        label="cancel",
        type = kPush,
        command = 
            function()
                CloseWindow(nil);
            end
    };
    
}

SetFocus( "nameedit" );
if (deleteselected) then
    EnableWindow("enterok",false);
end
if (GetNumUsers() == 0) then
    EnableWindow("entercancel",false);
end
SetImageAlpha("grayimage",0.4);
